<?php namespace Visiosoft\MotorcycleModule\Status;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\MotorcycleModule\Status\Contract\StatusRepositoryInterface;

class StatusSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(StatusRepositoryInterface $statusRepository)
    {
        $systemStatuses = [
            [
                'name' => 'Sıfır',
                'id' => 1,
            ],
            [
                'name' => 'İkinci El',
                'id' => 2,
            ],
            [
                'name' => 'Hasarlı',
                'id' => 3,
            ],
        ];


        foreach ($systemStatuses as $status) {
            if (!$statusRepository->allWithTrashed()->findBy('id', $status['id'])) {
                $statusRepository->create([
                    'en' => [
                        'name' => $status['name']
                    ],
                    'id' => $status['id'],
                ]);
            }
        }
    }
}
