<?php namespace Visiosoft\MotorcycleModule\NotificationSeeder;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;

class NotificationSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {
            $templates = [
                [
                    'slug' => 'transport_status_changed',
                    'en' => [
                        'name' => 'Nakliye durumu güncellendi',
                        'subject' => 'Nakliye durumu güncellendi',
                        'greeting' => 'Merhaba',
                        'message' => '
<p><strong>{transport_id} numaralı taşıma işleminizin durumu "{status_name}" olarak güncellenmiştir.</strong></p>&nbsp;
<p>Nakliye detayları için <a href="{transport_detail_url}" target="_blank">bu</a> adresi ziyaret edebilirsiniz. </p>'
                    ],
                    'stream' => 'visiosoft.module.motorcycle',
                ],
                [
                    'slug' => 'admin_transport_created',
                    'en' => [
                        'name' => 'Nakliye isteği oluşturuldu.',
                        'subject' => 'Nakliye isteği oluşturuldu.',
                        'greeting' => 'Merhaba',
                        'message' => '
<p><strong>{transport_id} numaralı yeni bir transfer isteği oluşturuldu.</strong></p>&nbsp;
<p>Nakliye detayları için <a href="{transport_detail_url}" target="_blank">bu</a> adresi ziyaret edebilirsiniz. </p>'
                    ],
                    'stream' => 'visiosoft.module.motorcycle',
                ]
            ];


            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }

        }
    }
}
