<?php namespace Visiosoft\MotorcycleModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
class MotorcycleModulePlugin extends Plugin
{
    protected $categoryRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getSubCatBySlug',
                function ($slug) {
                    return $this->categoryRepository->getSubCatsByParentSlug($slug);
                }
            )];
    }
}
