<?php namespace Visiosoft\MortgageCalculatorModule\InterestRate\Handler;

use Anomaly\SelectFieldType\SelectFieldType;
use Visiosoft\MortgageCalculatorModule\InterestRate\Contract\InterestRateRepositoryInterface;


class CalcInterestRateHandler
{
    public function handle(SelectFieldType $fieldType)
    {
        $interestRepository = app(InterestRateRepositoryInterface::class);
        $arr = [];
        foreach ($interestRepository->all() as $item) {
            $arr[$item->getAttributeValue('slug')] = $item->getAttributeValue('name') . ' (%' . $item->getAttributeValue('interest_rate') . ')';
        }
        $fieldType->setOptions($arr);
    }
}