<?php namespace Visiosoft\MortgageCalculatorModule\InterestRate\Form;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\ResponseFactory;
use Visiosoft\MortgageCalculatorModule\Http\Controller\CalcController;
use Anomaly\Streams\Platform\Support\Collection;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

/**
 * Class ContactFormHandler
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 */
class CalcFormHandler
{

    use DispatchesJobs;

    /**
     * Handle the command.
     *
     * @param FormBuilder $builder
     */
    public function handle(FormBuilder $builder, Collection $data, ResponseFactory $response)
    {
        // Validation failed!
        if ($builder->hasFormErrors()) {
            return;
        }

        $options = [
            'loan_amount' => $builder->getForm()->getValue('loan_amount'),
            'interest_rate' => $builder->getForm()->getValue('interest_rate'),
            'loan_term' => $builder->getForm()->getValue('loan_term'),
            'loan_month' => $builder->getForm()->getValue('time')->format("m"),
            'loan_years' => $builder->getForm()->getValue('time')->format("Y"),
        ];
        $CreditCalc = app(CalcController::class);
        $Response = $CreditCalc->calc($options);
        $data->put('success', $Response['status']);
        $data->put('errors', $Response['error_messages']);
        $data->put('data', $Response['data']);


        $builder->setFormResponse(
            $response = $response->json($data)
        );
    }
}
