<?php namespace Visiosoft\MortgageCalculatorModule\InterestRate\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

/**
 * Class CalcFormBuilder
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 */
class CalcFormBuilder extends FormBuilder
{

    protected $ajax = true;
    /**
     * The form handler.
     *
     * @var CalcFormHandler
     */
    protected $handler = CalcFormHandler::class;

    /**
     * The form fields.
     *
     * @var array
     */
    protected $fields = [
        'loan_amount' => [
            'label' => 'visiosoft.module.mortgage_calculator::field.loan_amount.name',
            'type' => 'anomaly.field_type.decimal',
            'required' => true,
        ],
        'interest_rate' => [
            'label' => 'visiosoft.module.mortgage_calculator::field.interest_rate.name',
            'type' => 'anomaly.field_type.select',
            'placeholder' => 'visiosoft.module.mortgage_calculator::view.choose_option',
            "config" => [
                "handler" => "Visiosoft\MortgageCalculatorModule\InterestRate\Handler\CalcInterestRateHandler@handle"
            ],
            'required' => true,
        ],
        'loan_term' => [
            'label' => 'visiosoft.module.mortgage_calculator::field.loan_term.name',
            'type' => 'anomaly.field_type.integer',
            'required' => true,
        ],
        'time' => [
            'label' => 'visiosoft.module.mortgage_calculator::field.first_payment.name',
            'type' => 'anomaly.field_type.datetime',
            "config" => [
                "default_value" => null,
                "mode" => "date",
                "date_format" => "j F, Y",
                "year_range" => "-50:+50",
                "timezone" => null,
                "picker" => true,
            ],
            'required' => true,
        ],

    ];

    /**
     * The form actions.
     *
     * @var array
     */
    protected $actions = [
        'submit' => [
            'text' => 'visiosoft.module.mortgage_calculator::button.calc'
        ],
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'breadcrumb' => false,
        'redirect' => false,
    ];

}
