<?php


namespace Visiosoft\MortgageCalculatorModule\Http\Controller;


use Anomaly\Streams\Platform\Support\Currency;
use Illuminate\Routing\Controller;
use Visiosoft\MortgageCalculatorModule\InterestRate\Contract\InterestRateRepositoryInterface;
use Visiosoft\MortgageCalculatorModule\Loan\HousingLoan;

class CalcController extends Controller
{
    /**
     * @var InterestRateRepositoryInterface
     */
    private $interesentRepository;
    /**
     * @var Currency
     */
    private $currency;

    public function __construct(
        InterestRateRepositoryInterface $interestRepository,
        Currency $Currency
    )
    {
        $this->interestRepository = $interestRepository;
        $this->currency = $Currency;

    }

    public function calc($options)
    {

        $errorMessages = array();
        $result = array(
            'status' => False,
            'data' => [],
            'error_messages' => []
        );
        $loanAmount = $options['loan_amount'];
        $interestRateSlug = $options['interest_rate'];
        $interestRateModel = $this->interestRepository->findBy('slug', $interestRateSlug);
        if (!$interestRateModel) {
            $errorMessages['interest_rate'] = trans('visiosoft.module.mortgage_calculator::message.interest_rate_is_not_found');
            $interestRate = 0;
        } else {
            $interestRate = $interestRateModel->getAttributeValue('interest_rate');
        }
        $loanTerm = $options['loan_term'];
        $firstPaymentMonth = $options['loan_month'];
        $firstPaymentYears = $options['loan_years'];

        if (!is_numeric($loanAmount)) {
            $errorMessages['loan_amount'][] = trans('visiosoft.module.mortgage_calculator::message.loan_amount_is_not_valid');
        }
        if (!is_numeric($loanTerm)) {
            $errorMessages['loan_term'][] = trans('visiosoft.module.mortgage_calculator::message.loan_term_is_not_valid');
        }
        if (!is_numeric($interestRate)) {
            $errorMessages['interest_rate'][] = trans('visiosoft.module.mortgage_calculator::message.interest_rate_is_not_valid');
        }
        if (count($errorMessages)) {

            $result['error_messages'] = $errorMessages;
        } else {
            $housingLoan = new HousingLoan();
            $housingLoan->setLoanAmount($loanAmount);
            $housingLoan->setInterestRate($interestRate);
            $housingLoan->setLoanTerm($loanTerm * 12);
            $housingLoan->setLoanStart($firstPaymentMonth, $firstPaymentYears);
            $monthlyPayments = $housingLoan->getMonthlyPayments();
            if (is_nan($monthlyPayments)) {
                $result['error_messages']['monthly_payments'][] = trans('visiosoft.module.mortgage_calculator::message.the_result_number_is_too_large');
            } else {
                $result['status'] = True;
                $PaymentPlan = $housingLoan->getPaymentPlan();
                foreach ($PaymentPlan as $key => $item) {
                    $PaymentPlan[$key]['principal'] = $this->currency->normalize($item['principal']);
                    $PaymentPlan[$key]['interest'] = $this->currency->normalize($item['interest']);
                    $PaymentPlan[$key]['balance'] = $this->currency->normalize($item['balance']);
                }
                $result['data'] = array(
                    'monthly_payments' => $this->currency->normalize($monthlyPayments),
                    'payment_plan' => $PaymentPlan,
                    'total_payment' => $this->currency->normalize($housingLoan->getTotalPayment()),
                    'total_interest' => $this->currency->normalize($housingLoan->getTotalInterest())
                );
            }
        }
        return $result;
    }
}