<?php namespace Visiosoft\MortgageCalculatorModule\Http\Controller\Admin;

use Visiosoft\MortgageCalculatorModule\InterestRate\Form\InterestRateFormBuilder;
use Visiosoft\MortgageCalculatorModule\InterestRate\Table\InterestRateTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class InterestRateController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param InterestRateTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(InterestRateTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param InterestRateFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(InterestRateFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param InterestRateFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(InterestRateFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function calc()
    {
        return $this->view->make('visiosoft.module.mortgage_calculator::admin_calc_index');
    }
}
