$(document).ready(function () {
    $('#CreditCalcForm').submit(function () {
        var action = $(this).attr('action');
        var postData = {
            _token: $('[name=_token]').val(),
            loan_amount: $('[name=loan_amount]').val(),
            interest_rate: $('[name=interest_rate]').val(),
            loan_term: $('[name=loan_term]').val(),
            time: $('[name=time]').val(),
        };
        $.post(action, postData,
            function (data) {
                if (data.success) {
                    var tbodyHtml = '';
                    var paymentPlan = data.data.payment_plan;
                    for (var i = 0; i < paymentPlan.length; i++) {
                        tbodyHtml += '  <tr>\n' +
                            '                            <td>' + paymentPlan[i].date + '</td>\n' +
                            '                            <td>' + paymentPlan[i].principal + '</td>\n' +
                            '                            <td>' + paymentPlan[i].interest + '</td>\n' +
                            '                            <td>' + paymentPlan[i].balance + '</td>\n' +
                            '                        </tr>';
                    }
                    $('.table > tbody').html(tbodyHtml);
                    $('#monthly_payments').text(data.data.monthly_payments);
                    $('#payoff_date').text(paymentPlan[paymentPlan.length - 1].date);
                    $('#total_interest').text(data.data.total_interest);
                    $('#total_payment').text(data.data.total_payment);
                    $('#payment_plan').text(paymentPlan.length);
                    $('#DetailsModal').modal('show');
                }

            }
        );

        return false;
    });
});

