<?php namespace Visiosoft\MessagesModule\Chat;

use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ChatRepository extends EntryRepository implements ChatRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ChatModel
     */
    protected $model;

    /**
     * Create a new ChatRepository instance.
     *
     * @param ChatModel $model
     */
    public function __construct(ChatModel $model)
    {
        $this->model = $model;
    }

    public function getOtherUser($chatId, $userId = null) {
        if (!$userId) {
            $userId = auth()->id();
        }
        $chat = $this->find($chatId);
        return $chat->user_1_id == $userId ? $chat->user_2 : $chat->user_1;
    }

    public function getChats($userId = null) {
        $userId = auth_id_if_null($userId);

        $query = $this->newQuery();

        if (is_array($userId)) {
            $query = $query
                ->whereIn('user_1_id', $userId)
                ->orWhereIn('user_2_id', $userId);
        } else {
            $query = $query
                ->where('user_1_id', $userId)
                ->orWhere('user_2_id', $userId);
        }

        return $query
            ->orderBy('updated_at', 'DESC')
            ->get();
    }

    public function findChatByUsers($user1, $user2 = null) {
        if (!$user2) {
            $user2 = auth()->id();
        }

        return $this
            ->newQuery()
            ->whereNull('adv_id')
            ->where(function ($query) use ($user1, $user2) {
                $query->where('user_1_id', $user1)
                    ->where('user_2_id', $user2);
            })
            ->orWhere(function ($query) use ($user1, $user2) {
                $query->where('user_1_id', $user2)
                    ->where('user_2_id', $user1);
            })
            ->first();
    }

    public function findChatByAdv($adv, $userId = null) {
        if (!$userId) {
            $userId = auth()->id();
        }

        return $this
            ->newQuery()
            ->where(function ($query) use ($adv, $userId) {
                $query->where('user_1_id', $userId)
                    ->where('user_2_id', $adv->created_by_id);
            })
            ->orWhere(function ($query) use ($adv, $userId) {
                $query->where('user_1_id', $adv->created_by_id)
                    ->where('user_2_id', $userId);
            })
            ->where('adv_id', $adv->id)
            ->first();
    }
}
