$(document).ready(function () {
    // Scroll to the bottom of the chat wrapper
    scrollMsg()

    // Send button availability
    $("input[name=detail]").on('input', function () {
        if ($(this).val() !== "") {
            $('#send-chat').removeAttr("disabled")
        } else {
            $('#send-chat').attr("disabled", true)
        }
    })

    // Send message
    $('#messageForm').submit(function (e) {
        e.preventDefault();

        const detailInput = $("input[name=detail]")

        if (!detailInput.val().length) {
            return
        }

        $('.chat-wrapper').append(`
            <div class="message-inpage-details mx-3 user-message recent-msg">
                <div class="alert alert-success">
                    <p class="mb-0 text-dark">${detailInput.val()}</p>
                    <small class="mb-0 text-muted">${'now'}</small>
                </div>
            </div>
        `)

        scrollMsg();

        $.ajax({
            url: '/api/message/save',
            data: $(this).serialize(),
            method: 'POST',
        }).then(function (response) {
            if (response.success) {
                detailInput.val('')

                const recentMsg = $('.recent-msg')
                recentMsg.find('small').text(response.data.formatted_date)
                recentMsg.removeClass('recent-msg')
            } else {
                $('.recent-msg').remove()
            }
        }).catch(function () {
            $('.recent-msg').remove()
        })
    })

    // Receive message
    var pusher = new Pusher('a438f9c55b701d84abcc', {
        cluster: 'eu'
    });

    var channel = pusher.subscribe('MessageModuleOpenclassify');
    channel.bind(`Chat.${chatID}.Receiver.${authID}`, function (data) {
        $('.chat-wrapper').append(`
                <div class="message-inpage-details mx-3 anonymous-message recent-msg">
                    <div class="alert alert-secondary">
                        <p class="mb-0 text-dark">${data.data.detail}</p>
                        <small class="mb-0 text-muted">${data.data.formatted_date}</small>
                    </div>
                </div>
            `)

        scrollMsg()
    });
});

const scrollMsg = () => $('.chat-wrapper').scrollTop($('.chat-wrapper')[0].scrollHeight);
