<?php namespace Visiosoft\MessagesModule\Message;

use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class MessageRepository extends EntryRepository implements MessageRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var MessageModel
     */
    protected $model;

    /**
     * Create a new MessageRepository instance.
     *
     * @param MessageModel $model
     */
    public function __construct(MessageModel $model)
    {
        $this->model = $model;
    }

    public function addAttributes($messages)
    {
        foreach ($messages as $message) {
            $this->getUsersNames($message);
        }

        return $messages;
    }

    public function getUsersNames($message)
    {
        $senderName = $message->sender->display_name;
        $receiverName = $message->adv_user->display_name;
        if ($senderName != null) {
            $message->setAttribute('sender_name', $senderName);
        }
        if ($receiverName != null) {
            $message->setAttribute('receiver_name', $receiverName);
        }
        return $message;
    }

    public function getLatestMessage($chatId)
    {
        return $this
            ->newQuery()
            ->where('chat_id', $chatId)
            ->where(function ($query) {
                $query->whereNull('deleted_by_sender_id')
                    ->orWhere('deleted_by_sender_id', '!=', auth()->id());
            })
            ->where(function ($query) {
                $query->whereNull('deleted_by_receiver_id')
                    ->orWhere('deleted_by_receiver_id', '!=', auth()->id());
            })
            ->orderBy('created_at', 'DESC')
            ->first();
    }

    public function getUnreadMessagesCount($chatId, $userId = null)
    {
        if (!$userId) {
            $userId = auth()->id();
        }

        return $this
            ->newQuery()
            ->where('chat_id', $chatId)
            ->where('created_by_id', '!=', $userId)
            ->where('seen', 0)
            ->count();
    }
}
