<?php namespace Visiosoft\MessagesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\MessagesModule\Notification\Contract\NotificationRepositoryInterface;
use Visiosoft\MessagesModule\Notification\NotificationRepository;
use Anomaly\Streams\Platform\Model\Messages\MessagesNotificationsEntryModel;
use Visiosoft\MessagesModule\Notification\NotificationModel;
use Visiosoft\MessagesModule\MessageDetail\Contract\MessageDetailRepositoryInterface;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailRepository;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessageDetailsEntryModel;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailModel;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\MessagesModule\Message\MessageRepository;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;
use Visiosoft\MessagesModule\Message\MessageModel;
use Illuminate\Routing\Router;

class MessagesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/messages/message_details'           => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessageDetailsController@index',
        'admin/messages/message_details/create'    => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessageDetailsController@create',
        'admin/messages/message_details/edit/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessageDetailsController@edit',
        'admin/messages'           => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@index',
        'admin/messages/create'    => [
            'as' => 'user_message',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@sendUser',
        ],
        'admin/messages/store'    => [
            'as' => 'user_store',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@storeUser',
        ],
        'admin/messages/save/all'    => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@saveAll',
        'admin/messages/edit/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@edit',
        'admin/messages/send/{adv_id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@send',
        'admin/messages/show/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@show',
        'admin/messages/show/{id}/save' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@save',
        'messages' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@list',
        'message/{adv_id}' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@check',
        'message/{adv_id}/save' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@firstSave',
        'message/{id}/detail' => [
            'as' => 'message_details',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@show'
        ],
        'message/{id}/detail/save' => [
            'as' => 'save_message_details',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@save'
        ],
        'api/messages' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@list',
        'api/message/{adv_id}/save' => [
            'as' => 'visiosoft.module.messages::save_message',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@save'
        ],
        'api/message/{id}/detail' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@show',
        'api/message/{id}/detail/update' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@update',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\MessagesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\MessagesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\MessagesModule\Event\ExampleEvent::class => [
        //    Visiosoft\MessagesModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\MessagesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        MessagesNotificationsEntryModel::class => NotificationModel::class,
        MessagesMessageDetailsEntryModel::class => MessageDetailModel::class,
        MessagesMessagesEntryModel::class => MessageModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        NotificationRepositoryInterface::class => NotificationRepository::class,
        MessageDetailRepositoryInterface::class => MessageDetailRepository::class,
        MessageRepositoryInterface::class => MessageRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
