<?php namespace Visiosoft\MessagesModule\Http\Controller;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Visiosoft\MessagesModule\Message\Form\MessageFormBuilder;
use Visiosoft\MessagesModule\Message\Table\MessageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\MessagesModule\Message\MessageModel;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailModel;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;

class MessagesController extends AdminController
{
    public function list()
    {
        $messages = MessageModel::where('adv_user_id', auth()->id())->orWhere('sender_id',auth()->id())->get();
        return $this->view->make('visiosoft.module.messages::messages/messages', compact('messages'));
    }
    public function check($adv_id)
    {
        $message = MessageModel::where('adv_id', $adv_id)->where('sender_id',auth()->id())->first();
        if($message){
            return redirect('messages/show/'.$message->id.'/detail');
        }
        return $this->view->make('visiosoft.module.messages::messages/first_message', compact('adv_id'));
    }
    public function firstSave($adv_id, Request $request)
    {
        $adv_user = AdvModel::find($adv_id);
        $message = new MessageModel();
        $message['adv_id'] = $adv_id;
        $message['title'] = $adv_user->name;
        $message['sender_id'] = auth()->id();
        $message['adv_user_id'] = $adv_user->created_by_id;
        if($message->save()){
            $message_detail = new MessageDetailModel();
            $message_detail['detail'] = $request->detail;
            $message_detail['message_id'] = $message->id;
            $message_detail['sent_at'] = date('y-m-d H:i:s');
            $message_detail['sender_id'] = auth()->id();
            $message_detail->save();   
            return redirect('message/'.$message->id.'/detail');                
        }
        return redirect()->back();
    }
    public function show($id)
    {
        $message = MessageModel::find($id);
        if($message){
            $adv = AdvsAdvsEntryModel::query()->where('advs_advs.id', $message['adv_id'])->first();
            $advModel = new AdvModel();
            $adv->detail_url = $advModel->getAdvDetailLinkByModel($adv,'list');
            $adv = $advModel->AddAdsDefaultCoverImage($adv);
            $message['status'] = true;
            $message['sender_status'] = true;
            $message->save();
            $message_details = MessageDetailModel::where('message_id', $message->id)->get();    
            return $this->view->make('visiosoft.module.messages::messages/message', compact('message', 'message_details', 'adv'));
        }
        abort(404);
    }
    public function save($id, Request $request)
    {
        $message = MessageModel::find($id);
        if($message){
            $message_detail = new MessageDetailModel();
            $message_detail['detail'] = $request->detail;
            $message_detail['message_id'] = $id;
            $message_detail['sent_at'] = date('y-m-d H:i:s');
            $message_detail['sender_id'] = auth()->id();
            $message_detail->save();                   
        }
        return redirect()->back();
    }
}
