<?php namespace Visiosoft\MessagesModule\Http\Controller\Api;

use Visiosoft\MessagesModule\Message\Form\MessageFormBuilder;
use Visiosoft\MessagesModule\Message\Table\MessageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\MessagesModule\Message\MessageModel;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailModel;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;

class MessagesController extends AdminController
{
    public function list()
    {
        $messages = MessageModel::where('adv_user_id', auth()->id())->orWhere('sender_id',auth()->id())->get();
        return response()->json($messages);
    }
    public function save($adv_id, Request $request)
    {
        $message = MessageModel::where('adv_id', $adv_id)->where('sender_id',auth()->id())->first();
        if($message){
            $message_detail = new MessageDetailModel();
            $message_detail['detail'] = $request->detail;
            $message_detail['message_id'] = $adv_id;
            $message_detail['sent_at'] = date('y-m-d H:i:s');
            $message_detail['sender_id'] = auth()->id();
            if($message_detail->save()){         
                return response()->json(['status' => 'success']);
            }else{
                return response()->json(['status' => 'fail']);
            }
        }else{
            $adv_user = AdvModel::find($adv_id);
            $message = new MessageModel();
            $message['adv_id'] = $adv_id;
            $message['title'] = $adv_user->name;
            $message['sender_id'] = auth()->id();
            $message['adv_user_id'] = $adv_user->created_by_id;
            if($message->save()){
                $message_detail = new MessageDetailModel();
                $message_detail['detail'] = $request->detail;
                $message_detail['message_id'] = $message->id;
                $message_detail['sent_at'] = date('y-m-d H:i:s');
                $message_detail['sender_id'] = auth()->id();
                if($message_detail->save()){         
                    return response()->json(['status' => 'success']);
                }else{
                    return response()->json(['status' => 'fail']);
                }
            }
        }
    }
    public function show($id)
    {
        $message = MessagesMessagesEntryModel::find($id);
        if($message){
            $message['status'] = true;
            $message['sender_status'] = true;
            $message->save();
            $message_details = MessageDetailModel::where('message_id', $message->id)->get();
            return response()->json(['message' => $message, 'message_details' => $message_details]);
        }
        abort(404);
    }
    public function update($id, Request $request)
    {
        $message = MessageModel::find($id);
        if($message){
            $message_detail = new MessageDetailModel();
            $message_detail['detail'] = $request->detail;
            $message_detail['message_id'] = $id;
            $message_detail['sent_at'] = date('y-m-d H:i:s');
            $message_detail['sender_id'] = auth()->id();
            if($message_detail->save()){         
                return response()->json(['status' => 'success']);
            }else{
                return response()->json(['status' => 'fail']);
            }
        }else{
            return response()->json(['status' => 'fail']);
        }
    }
}
