<?php namespace Visiosoft\MessagesModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Visiosoft\MessagesModule\Message\Form\MessageFormBuilder;
use Visiosoft\MessagesModule\Message\Table\MessageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\MessagesModule\Message\MessageModel;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailModel;
use Illuminate\Http\Request;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\AdvsModule\Adv\AdvModel;

class MessagesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param MessageTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(MessageTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MessageFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(MessageFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MessageFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MessageFormBuilder $form, $id)
    {
        return $form->render($id);
    }
    public function show($id)
    {
        $message = MessageModel::find($id);
        if($message){
            $message_details = MessageDetailModel::where('message_id', $message->id)->get();       
        }
        return $this->view->make('visiosoft.module.advs::advs/message', compact('message', 'message_details'));
    }
    public function save($id, Request $request)
    {
        $message = MessageModel::find($id);
        if($message){
            $message_detail = new MessageDetailModel();
            $message_detail['detail'] = $request->detail;
            $message_detail['message_id'] = $id;
            $message_detail['sent_at'] = date('y-m-d H:i:s');
            $message_detail['sender_id'] = auth()->id();
            $message_detail->save();                   
        }
        return redirect()->back();
    }
    public function send($adv_id)
    {
        $message = MessageModel::where('adv_id', $adv_id)->where('sender_id',auth()->id())->first();
        if($message){
            $message_details = MessageDetailModel::where('message_id', $message->id)->get();       
        }else{
            $create = new MessageModel();
            $create['adv_id'] = $adv_id;
            $create['sender_id'] = auth()->id();
            $create->save();
            return redirect('admin/messages/show/'.$create->id);
        }
        return $this->view->make('visiosoft.module.advs::advs/message', compact('message', 'message_details'));
    }
    public function saveAll(Request $request)
    {
        $adv_user = AdvModel::find(1);
        $users = UserModel::all();
        foreach($users as $user){
            if($user->id!=auth()->id()){
                $message = new MessageModel();
                $message['title'] = $request->title;
                $message['adv_id'] = 0;
                $message['sender_id'] = auth()->id();
                $message['adv_user_id'] = $user->id;
                $message->save();
                $messaged = new MessageDetailModel();
                $messaged['message_id']=$message->id;
                $messaged['detail']=$request->detail;
                $messaged['sender_id']=0;
                $messaged['sent_at']=date('Y-m-d H:i:s');
                $messaged->save();
            }
        }
        return redirect()->back();
    }

    public function sendUser() {

        $users = UsersUsersEntryModel::all();
        return $this->view->make('visiosoft.module.messages::messages/send-user')->with('users', $users);
    }

    public function storeUser(Request $request) {
        $message = new MessageModel();
        $detail = new MessageDetailModel();

        $message->title = $request->title;
        $message->adv_user_id = $request->user_id;
        $message->sender = auth()->user()->id;
        $message->title = $request->title;
        $message->adv_id = null;

        if ($message->save()) {
            $detail->detail = $request->detail;
            $detail->message_id = null;
            $detail->sender_id = auth()->user()->id;
            $detail->sent_at = date('Y-m-d H:i:s');
            $detail->message_id = $message->id;

            if ($detail->save()) {
                $this->messages->info(trans('visiosoft.module.messages::field.success'));
                return $this->redirect->route('user_message');
            }
        } else {
            return $this->redirect->route('user_message');
        }
    }
}
