<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\MessagesModule\RelatedMessage\RelatedMessageModel;

class VisiosoftModuleMessagesCreateMessagesFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class
            ]
        ],
        'adv_user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'deleted_by' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'from' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ],
        ],
        'to' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ],
        ],
        'ad_owner' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ],
        ],
        'customer' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ],
        ],
        'related' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => RelatedMessageModel::class
            ],
        ],
        'title' => 'anomaly.field_type.text',
        'detail' => [
            'type' => 'anomaly.field_type.textarea',
        ],
        'sent_at' => 'anomaly.field_type.datetime',
        'status' => [
            'type'   => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'sender_status' => [
            'type'   => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true,
            ],
        ],
        'readed_users' => 'anomaly.field_type.textarea',
    ];

}
