<?php namespace Visiosoft\MessagesModule\Listeners;

use Visiosoft\MessagesModule\Events\MessageCreated;
use Visiosoft\MessagesModule\Notifications\SendRealTimeMessage;

class DispatchRealTimeMessage
{
    public function handle(MessageCreated $event)
    {
        if (setting_value('visiosoft.module.messages::realtime_messages')) {
            $event->message->formatted_date = $event->message->created_at->format(config('streams::datetime.date_format') . ' ' . config('streams::datetime.time_format'));

            $event->message->getReceiver()->notify(new SendRealTimeMessage($event->message));
        }
    }
}
