<?php namespace Visiosoft\MessagesModule\Chat;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;

class ChatCriteria extends EntryCriteria
{
    /**
     * @var ChatRepositoryInterface
     */
    private $chatRepository;

    public function __construct(Builder $query, StreamInterface $stream, $method, ChatRepositoryInterface $chatRepository)
    {
        parent::__construct($query, $stream, $method);
        $this->chatRepository = $chatRepository;
    }

    public function getOtherUser($chatId, $userId = null) {
        return $this->chatRepository->getOtherUser($chatId, $userId);
    }
}
