<?php namespace Visiosoft\MessagesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessageDetailsEntryModel;
use Anomaly\Streams\Platform\Model\Messages\MessagesRelatedMessagesEntryModel;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\MessagesModule\Message\MessageRepository;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;
use Visiosoft\MessagesModule\Message\MessageModel;
use Illuminate\Routing\Router;
use Visiosoft\MessagesModule\RelatedMessage\Contract\RelatedMessageRepositoryInterface;
use Visiosoft\MessagesModule\RelatedMessage\RelatedMessageModel;
use Visiosoft\MessagesModule\RelatedMessage\RelatedMessageRepository;

class MessagesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/messages'           => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@index',
        'admin/messages/create'    => [
            'as' => 'user_message',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@sendUser',
        ],
        'admin/messages/store'    => [
            'as' => 'user_store',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@storeUser',
        ],
        'admin/messages/save/all'    => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@saveAll',
        'admin/messages/edit/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@edit',
        'admin/messages/send/{adv_id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@send',
        'admin/messages/show/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@show',
        'admin/messages/show/{id}/save' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@save',
        'messages' => [
            'as' => 'messages',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@listMessages'
        ],
        'message/{adv_id}/save' => [
            'as' => 'chat_message_save',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@firstSave'
        ],
        'message/{id}/detail' => [
            'as' => 'message_details',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@show'
        ],
        'messages/{id}/delete' => [
            'as' => 'messages_delete_all',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@deleteAll'
        ],
        'message/{id}/detail/save' => [
            'as' => 'save_message_details',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@save'
        ],
        'api/messages' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@listMessages',
        'api/message/{adv_id}/save' => [
            'as' => 'visiosoft.module.messages::save_message',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@save'
        ],
        'api/message/{id}/detail' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@show',
        'api/message/{id}/detail/update' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@update',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\MessagesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\MessagesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\MessagesModule\Event\ExampleEvent::class => [
        //    Visiosoft\MessagesModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\MessagesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        MessagesMessagesEntryModel::class => MessageModel::class,
        MessagesRelatedMessagesEntryModel::class => RelatedMessageModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        MessageRepositoryInterface::class => MessageRepository::class,
        RelatedMessageRepositoryInterface::class => RelatedMessageRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
