<?php namespace Visiosoft\MessagesModule\Message;

use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class MessageRepository extends EntryRepository implements MessageRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var MessageModel
     */
    protected $model;

    /**
     * Create a new MessageRepository instance.
     *
     * @param MessageModel $model
     */
    public function __construct(MessageModel $model)
    {
        $this->model = $model;
    }

    public function addAttributes($messages)
    {
        foreach ($messages as $message) {
            $this->getUsersNames($message);
        }

        return $messages;
    }

    public function getUsersNames($message)
    {
        $senderName = $message->sender->display_name;
        $receiverName = $message->adv_user->display_name;
        if ($senderName != null) {
            $message->setAttribute('sender_name', $senderName);
        }
        if ($receiverName != null) {
            $message->setAttribute('receiver_name', $receiverName);
        }
        return $message;
    }
}
