<?php namespace Visiosoft\MessagesModule\Events;

use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Support\Facades\Auth;

class MessageCreated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function broadcastOn()
    {
        return ['MessageModuleOpenclassify'];
    }

    public function broadcastAs()
    {
        $chat_entry = $this->data->chat;
        $chat_id = $chat_entry->id;
        $chat_reciever = Auth::id() == $chat_entry->user_2_id ? $chat_entry->user_1_id : $chat_entry->user_2_id;

        return "Chat.$chat_id.Receiver.$chat_reciever";
    }
}