<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\MessagesModule\Message\MessageModel;

class VisiosoftModuleMessagesCreateMessagesFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class
            ]
        ],
        'adv_user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'sender' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ],
        ],
        'message' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => MessageModel::class
            ],
        ],
        'title' => 'anomaly.field_type.text',
        'detail' => [
            'type' => 'anomaly.field_type.textarea',
        ],
        'sent_at' => 'anomaly.field_type.datetime',
        'status' => [
            'type'   => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'sender_status' => [
            'type'   => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true,
            ],
        ],
        'readed_users' => 'anomaly.field_type.textarea',
    ];

}
