<?php namespace Visiosoft\MessagesModule\Http\Controller;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $advRepository;
    private $advModel;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        AdvRepositoryInterface $advRepository,
        AdvModel $advModel
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->advRepository = $advRepository;
        $this->advModel = $advModel;
    }

    public function listMessages()
    {
        $messages = $this->messageRepository
            ->newQuery()
            ->where('adv_user_id', auth()->id())
            ->orWhere('sender_id',auth()->id())
            ->get();
        return $this->view->make('visiosoft.module.messages::messages/messages', compact('messages'));
    }

    public function check($adv_id)
    {
        $message = $this->messageRepository
            ->newQuery()
            ->where('adv_id', $adv_id)
            ->where('sender_id', auth()->id())
            ->first();
        if($message){
            return redirect('message/'.$message->id.'/detail');
        }
        return $this->view->make('visiosoft.module.messages::messages/first_message', compact('adv_id'));
    }

    public function firstSave($adv_id, Request $request)
    {
        $adv = $this->advRepository->find($adv_id);
        $message = $this->messageRepository->create([
            'adv_id' => $adv_id,
            'title' => $adv->name,
            'sender_id' => auth()->id(),
            'adv_user_id' => $adv->created_by_id,
            'detail' => $request->detail,
            'sent_at' => date('y-m-d H:i:s'),
        ]);
        return redirect('message/'.$message->id.'/detail');
    }

    public function show($id)
    {
        $message = $this->messageRepository->find($id);
        if ($message) {
            $adv = $this->advRepository->find($message['adv_id']);
            $adv->detail_url = $this->advModel->getAdvDetailLinkByModel($adv,'list');
            $adv = $this->advModel->AddAdsDefaultCoverImage($adv);
            $message->update([
                'status' => true,
                'sender_status' => true,
            ]);
            return $this->view->make('visiosoft.module.messages::messages/message', compact('message', 'adv'));
        }
        abort(404);
    }

    public function save($id, Request $request)
    {
        $message = $this->messageRepository->find($id);
        if ($message) {
            $message->update([
                'detail' => $request->detail,
                'sent_at' => date('y-m-d H:i:s'),
            ]);
        }
        return redirect()->back();
    }
}
