<?php namespace Visiosoft\MessagesModule\Message\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class MessageTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'title',
        'sender',
        'adv_user'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'title',
        'sender',
        'adv_user'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'read' => [
            'icon' => 'fa fa-eye',
            'type' => 'success',
            'href' => '/admin/messages/show/{entry.id}'
        ],
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
