<?php namespace Visiosoft\MessagesModule\Message;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Visiosoft\MessagesModule\Message\Contract\MessageInterface;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;
use Visiosoft\MessagesModule\MessageDetail\MessageDetailModel;

class MessageModel extends MessagesMessagesEntryModel implements MessageInterface
{
    public function listMessages() {
        $messages = MessageModel::query()->where('adv_user_id', auth()->id())->orWhere('sender_id',auth()->id())->get();
        foreach ($messages as $message) {
            $adv = AdvsAdvsEntryModel::query()->where('advs_advs.id', $message->adv_id)->first();
            $user = UsersUsersEntryModel::query()->where('users_users.id', $message->created_by_id)->first();
            if ($adv != null) {
                $message->setAttribute('adv_name', $adv->name);
                $message->setAttribute('adv_photo', $adv->cover_photo);
                $message->setAttribute('adv_owner', $user->first_name. " ". $user->last_name);
            } else {
                $message->setAttribute('adv_name', 'Admin');
                $message->setAttribute('adv_photo', null);
                $message->setAttribute('adv_owner', 'Admin');
            }
        }
        return $messages;
    }
    public function showMessage($id) {
            $message = MessageModel::find($id);
            if($message){
                $message['status'] = true;
                $message['sender_status'] = true;
                $message->save();
                $message_details = MessageDetailModel::where('message_id', $message->id)->get();
                return [$message, $message_details];
            }
            abort(404);
    }
}
