<?php namespace Visiosoft\MessagesModule\Message;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;

class MessageCriteria extends EntryCriteria
{
    private $messageRepository;
    private $advRepository;

    public function __construct
    (
        Builder $query,
        StreamInterface $stream,
        $method,
        MessageRepositoryInterface $messageRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        parent::__construct($query, $stream, $method);

        $this->messageRepository = $messageRepository;
        $this->advRepository = $advRepository;
    }

    public function getUserAdMessages($relationId) {
        // Mark unread messages
        $this->messageRepository
            ->newQuery()
            ->where('related_id', $relationId)
            ->where('to_id', auth()->id())
            ->where('seen', 0)
            ->update(['seen' => 1]);

        return $this->messageRepository
            ->newQuery()
            ->where('related_id', $relationId)
            ->orderBy('sent_at')
            ->get();
    }

    public function checkUnreadMessages() {
        return $this->messageRepository
            ->newQuery()
            ->where('to_id', auth()->id())
            ->where('seen', 0)
            ->count();
    }
}