<?php namespace Visiosoft\MessagesModule\Http\Controller;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\MessagesModule\RelatedMessage\Contract\RelatedMessageRepositoryInterface;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $relatedMessageRepository;
    private $advRepository;
    private $advModel;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        RelatedMessageRepositoryInterface $relatedMessageRepository,
        AdvRepositoryInterface $advRepository,
        AdvModel $advModel
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->relatedMessageRepository = $relatedMessageRepository;
        $this->advRepository = $advRepository;
        $this->advModel = $advModel;
    }

    public function listMessages()
    {
        $messagesRelations = $this->relatedMessageRepository
            ->newQuery()
            ->where(function ($query) {
                $query->where('deleted_by_id', '!=', auth()->id())
                    ->orWhereNull('deleted_by_id');
            })
            ->where(function ($query) {
                $query->where('ad_owner_id', auth()->id())
                    ->orWhere('customer_id', auth()->id());
            })
            ->orderBy('updated_at', 'DESC')
            ->get();
        $chats = array();
        foreach ($messagesRelations as $messagesRelation) {
            $unreadMessages = $this->messageRepository
                ->newQuery()
                ->where('related_id', $messagesRelation->id)
                ->where('to_id', auth()->id())
                ->where('seen', 0)
                ->count();
            $chats[] = [
                'chat' => $messagesRelation,
                'unreadMessages' => $unreadMessages
            ];
        }
        return $this->view->make('visiosoft.module.messages::messages/messages', compact('chats'));
    }

    public function firstSave($advId, Request $request)
    {
        $adv = $this->advRepository->find($advId);

        $to = $adv->created_by_id;

        if (isset($request['relation']) && !empty($request['relation'])) {
            $relation = $this->relatedMessageRepository->find($request['relation']);
            if ($relation->customer_id !== auth()->id()) {
                $to = $relation->customer_id;
            }
            $relation->update();
        } else {
            $relation = $this->relatedMessageRepository
                ->newQuery()
                ->where('customer_id', auth()->id())
                ->where('ad_owner_id', $adv->created_by_id)
                ->where('adv_id', $advId)
                ->first();
            if (is_null($relation)) {
                $relation = $this->relatedMessageRepository->create([
                    'customer' => auth()->id(),
                    'ad_owner' => $adv->created_by_id,
                    'adv_id' => $advId
                ]);
            } else {
                $relation->update();
            }
        }

        $message = $this->messageRepository->create([
            'adv_id' => $advId,
            'title' => $adv->name,
            'from_id' => auth()->id(),
            'to_id' => $to,
            'adv_user_id' => $adv->created_by_id,
            'detail' => $request->detail,
            'sent_at' => date('y-m-d H:i:s'),
            'related' => $relation,
        ]);
        return redirect()->back();
    }

    public function show($relationId)
    {
        $relation = $this->relatedMessageRepository->find($relationId);
        if ($relation) {
            $adv = $relation->adv;
            $adv->detail_url = $this->advModel->getAdvDetailLinkByModel($adv,'list');
            $adv = $this->advModel->AddAdsDefaultCoverImage($adv);
            return $this->view->make('visiosoft.module.messages::messages/message', compact('relation', 'adv'));
        }
        abort(404);
    }

    public function save($id, Request $request)
    {
        $message = $this->messageRepository->find($id);
        if ($message) {
            $message->update([
                'detail' => $request->detail,
                'sent_at' => date('y-m-d H:i:s'),
            ]);
        }
        return redirect()->back();
    }

    public function deleteAll($relationId)
    {
        $relation = $this->relatedMessageRepository->find($relationId);

        if (!is_null($relation->deleted_by_id)) {
            $this->messageRepository
                ->newQuery()
                ->where('related_id', $relationId)
                ->delete();
            $relation->delete();
        } else {
            $this->messageRepository
                ->newQuery()
                ->where('related_id', $relationId)
                ->where('to_id', auth()->id())
                ->update(['seen' => 1]);

            $relation->update([
                'deleted_by_id' => auth()->id()
            ]);
        }

        return redirect()->back();
    }
}
