<?php namespace Visiosoft\MessagesModule\Http\Controller\Admin;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\MessagesModule\Message\Form\MessageFormBuilder;
use Visiosoft\MessagesModule\Message\Table\MessageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Http\Request;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $advRepository;
    private $userRepository;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        AdvRepositoryInterface $advRepository,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->advRepository = $advRepository;
        $this->userRepository = $userRepository;
    }

    /**
     * Display an index of existing entries.
     *
     * @param MessageTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(MessageTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MessageFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(MessageFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MessageFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MessageFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function show($id)
    {
        $message = $this->messageRepository->find($id);
        return $this->view->make('visiosoft.module.messages::message', compact('message', 'message_details'));
    }

    public function send($adv_id)
    {
        $message = $this->messageRepository->newQuery()->where('adv_id', $adv_id)->where('sender_id', auth()->id())->first();
        if (is_null($message)){
            $message = $this->messageRepository->create([
                'adv_id' => $adv_id,
                'sender_id' => auth()->id()
            ]);
            return redirect('admin/messages/show/' . $message->id);
        }
        return $this->view->make('visiosoft.module.messages::message', compact('message'));
    }

    public function saveAll(Request $request)
    {
        $users = $this->userRepository->all();
        foreach ($users as $user) {
            if ($user->id != auth()->id()) {
                $this->messageRepository->create([
                    'title' => $request->title,
                    'adv_id' => 0,
                    'sender_id' => auth()->id(),
                    'adv_user_id' => $user->id,
                    'detail' => $request->detail,
                    'sent_at' => date('Y-m-d H:i:s')
                ]);
            }
        }
        return redirect()->back();
    }

    public function sendUser() {
        $users = $this->userRepository->all();
        return $this->view->make('visiosoft.module.messages::messages/send-user')->with('users', $users);
    }

    public function storeUser(Request $request) {
        $this->messageRepository->create([
            'title' => $request->title,
            'adv_user_id' => $request->user_id,
            'sender_id' => auth()->user()->id,
            'adv_id' => null,
            'detail' => $request->detail,
            'sent_at' => date('Y-m-d H:i:s'),
        ]);

        $this->messages->info(trans('visiosoft.module.messages::field.success'));
        return $this->redirect->route('user_message');
    }
}
