<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMessagesCreateRelatedMessagesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'related_messages',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'ad_owner' => [
            'required' => true,
        ],
        'customer' => [
            'required' => true,
        ],
        'adv' => [
            'required' => true,
        ],
        'deleted_by'
    ];

}
