<?php namespace Visiosoft\MessagesModule\Http\Controller\Api;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Illuminate\Http\Request;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $advRepository;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->advRepository = $advRepository;
    }

    public function listMessages(Request $request)
    {
        if ($request->type == 'inbox') {
            $messages = $this->messageRepository->newQuery()->where('adv_user_id', auth()->id())->get();
        } else {
            $messages = $this->messageRepository->newQuery()->Where('sender_id',auth()->id())->get();
        }
        $messages = $this->messageRepository->addAttributes($messages);
        return response()->json($messages);
    }

    public function save($adv_id, Request $request)
    {
        $message = $this->messageRepository
            ->newQuery()
            ->where('adv_id', $adv_id)
            ->where('sender_id', auth()->id())
            ->first();
        if (is_null($message)) {
            $adv = $this->advRepository->find($adv_id);
            $message = $this->messageRepository->create([
                'adv' => $adv,
                'title' => $adv->name,
                'sender_id' => auth()->id(),
                'adv_user_id' => $adv->created_by_id,
                'detail' => $request->detail,
                'sent_at' => date('y-m-d H:i:s'),
            ]);
            return response()->json(['status' => 'success', 'message' => $message]);
        }
    }

    public function show($id)
    {
        $message = $this->messageRepository->find($id);
        if (!is_null($message)) {
            $message->update([
                'status' => true,
                'sender_status' => true,
            ]);
            return response()->json(['message' => $message]);
        }
        abort(404);
    }

    public function update($id, Request $request)
    {
        $message = $this->messageRepository->find($id);
        if (!is_null($message)) {
            $message->update([
                'detail' => $request->detail,
                'sent_at' => date('y-m-d H:i:s'),
                'sender_id' => auth()->id(),
            ]);
            return response()->json(['status' => 'success', 'message' => $message]);
        } else {
            return response()->json(['status' => 'fail']);
        }
    }
}
