<?php namespace Visiosoft\MessagesModule\Listeners;

use Anomaly\Streams\Platform\Addon\Module\Event\ModuleWasInstalled;

class AddEnvVars
{
    public function handle(ModuleWasInstalled $event)
    {
        if ($event->getModule()->getNamespace() === 'visiosoft.module.messages') {
            $path = base_path('.env');

            if (file_exists($path)) {
                if(strpos(file_get_contents($path), 'PUSHER_APP_ID') === false) {
                    file_put_contents($path, file_get_contents($path) . <<<env

                    BROADCAST_DRIVER=pusher
                    PUSHER_APP_ID=236330
                    PUSHER_APP_KEY=236330
                    PUSHER_APP_SECRET=236330
                    PUSHER_APP_CLUSTER=eu9

                    env);
                }
            }
        }
    }
}
