<?php namespace Visiosoft\MessagesModule\Message\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class MessageTableBuilder extends TableBuilder
{
    protected $filters = [
        'title',
        'chat'
    ];

    protected $columns = [
        'entry.id',
        'entry.created_at',
        'sender' => 'entry.created_by.name',
        'receiver' => 'entry.getReceiver.name',
        'chat',
    ];

    protected $buttons = [
        'read' => [
            'icon' => 'fa fa-eye',
            'type' => 'success',
            'href' => '/admin/messages/show/{entry.id}'
        ],
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
        'order_by' => [
            'created_at' => 'DESC'
        ]
    ];
}
