<?php namespace Visiosoft\MessagesModule\Http\Controller;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\AdvsModule\Adv\AdvModel;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $chatRepository;
    private $advRepository;
    private $advModel;
    private $userRepository;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        ChatRepositoryInterface $chatRepository,
        AdvRepositoryInterface $advRepository,
        AdvModel $advModel,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->chatRepository = $chatRepository;
        $this->advRepository = $advRepository;
        $this->advModel = $advModel;
        $this->userRepository = $userRepository;
    }

    public function listMessages()
    {
        if (!$keyword = request('keyword')) {
            $users = null;
        } else {
            $users = $this->userRepository->newQuery()
                ->where('first_name', 'LIKE', "%$keyword%")
                ->orWhere('last_name', 'LIKE', "%$keyword%")
                ->orWhere('email', 'LIKE', "%$keyword%")
                ->pluck('id')
                ->all();
        }

        // Get chats
        $chats = $this->chatRepository->getChats($users);
        $allChats = [];
        $totalUnread = 0;
        foreach ($chats as $index => $chat) {
            // Check if chat has messages
            $latestMessage = $this->messageRepository->getLatestMessage($chat->id);
            if (!$latestMessage) {
                unset($chats[$index]);
                continue;
            }
            // Get unread messages count
            $unreadMessagesCount = $this->messageRepository->getUnreadMessagesCount($chat->id);
            $chat->setAttribute('unread_messages_count', $unreadMessagesCount);
            if ($unreadMessagesCount >0) {
                $totalUnread ++;
                $allChats['unread'][] = $chat;
            }else{
                $allChats['read'][] = $chat;
            }
            $chat->setAttribute('latest_message_title', $latestMessage->detail);
        }
        return $this->view->make('visiosoft.module.messages::messages/list-messages', compact('allChats', 'chats', 'totalUnread'));
    }

    public function save($advId = null)
    {
        if (isset(request()->chat) && !empty(request()->chat)) {
            $chat = $this->chatRepository->find(request()->chat);
        } elseif (isset(request()->send_to) && !empty(request()->send_to)) {
            $chat = $this->chatRepository->findChatByUsers(request()->send_to);
            if (is_null($chat)) {
                $chat = $this->chatRepository->create([
                    'user_1_id' => auth()->id(),
                    'user_2_id' => request()->send_to,
                ]);
            }
        } else {
            $adv = $this->advRepository->find($advId);
            $chat = $this->chatRepository->findChatByAdv($adv);
            if (is_null($chat)) {
                $chat = $this->chatRepository->create([
                    'user_1_id' => auth()->id(),
                    'user_2_id' => $adv->created_by_id,
                    'adv_id' => $advId
                ]);
            }
        }
        $chat->update();

        $otherUser = $this->chatRepository->getOtherUser($chat->id);
        $this->messageRepository->create([
            'title' => $otherUser->name(),
            'detail' =>request()->adv_url . " " . request()->detail,
            'chat' => $chat,
        ]);

        $this->messages->success(trans('visiosoft.module.messages::message.message_sent'));

        return redirect()->back();
    }

    public function show($chatId)
    {
        $chat = $this->chatRepository->find($chatId);
        $isAuthenticated = $chat->user_1_id == Auth::id() || $chat->user_2_id == Auth::id();
        if ($chat && $isAuthenticated) {
            $adv = $chat->adv;
            if ($adv) {
                $adv->detail_url = $this->advModel->getAdvDetailLinkByModel($adv,'list');
                $adv = $this->advModel->AddAdsDefaultCoverImage($adv);
            }
            return $this->view->make('visiosoft.module.messages::messages/show-message', compact('chat', 'adv','chatId'));
        }
        return redirect('/');
    }

    public function deleteAll($chatId)
    {
        $messages = $this->messageRepository->newQuery()->where('chat_id', $chatId)->get();
        foreach ($messages as $message) {
            if ($message->created_by_id == auth()->id()) {
                $message->update(['deleted_by_sender_id' => auth()->id()]);
            } else {
                $message->update(['deleted_by_receiver_id' => auth()->id()]);
            }
        }

        $this->messageRepository
            ->newQuery()
            ->where('chat_id', $chatId)
            ->where('created_by_id', '!=', auth()->id())
            ->update(['seen' => 1]);

        return redirect()->back();
    }
}
