<?php namespace Visiosoft\MessagesModule\Http\Controller\Admin;

use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\MessagesModule\Message\Form\MessageFormBuilder;
use Visiosoft\MessagesModule\Message\Table\MessageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class MessagesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param MessageTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(MessageTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MessageFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(MessageFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MessageFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MessageFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function show($id, MessageRepositoryInterface $messageRepository)
    {
        $message = $messageRepository->find($id);
        return $this->view->make('visiosoft.module.messages::admin.show-message', compact('message'));
    }
}
