<?php namespace Visiosoft\MessagesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Addon\Module\Event\ModuleWasInstalled;
use Anomaly\Streams\Platform\Model\Messages\MessagesChatsEntryModel;
use BeyondCode\LaravelWebSockets\WebSocketsServiceProvider;
use Illuminate\Support\Facades\Broadcast;
use Visiosoft\MessagesModule\Chat\ChatModel;
use Visiosoft\MessagesModule\Chat\ChatRepository;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Events\MessageCreated;
use Visiosoft\MessagesModule\Listeners\AddEnvVars;
use Visiosoft\MessagesModule\Listeners\DispatchRealTimeMessage;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\MessagesModule\Message\MessageRepository;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;
use Visiosoft\MessagesModule\Message\MessageModel;

class MessagesModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/messages'           => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@index',
        'admin/messages/create'    => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@create',
        'admin/messages/edit/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@edit',
        'admin/messages/show/{id}' => 'Visiosoft\MessagesModule\Http\Controller\Admin\MessagesController@show',

        'messages' => [
            'as' => 'messages',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@listMessages'
        ],
        'message/save/{adv_id?}' => [
            'as' => 'chat_message_save',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@save'
        ],
        'message/{id}/detail' => [
            'as' => 'message_details',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@show'
        ],
        'messages/{id}/delete' => [
            'as' => 'messages_delete_all',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\MessagesController@deleteAll'
        ],
        'api/messages' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@listMessages',
        'api/message/save' => [
            'as' => 'visiosoft.module.messages::save_message',
            'uses' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@save'
        ],
        'api/message/{id}/detail' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@show',
        'api/message/{id}/detail/update' => 'Visiosoft\MessagesModule\Http\Controller\Api\MessagesController@update',
    ];

    protected $listeners = [
        MessageCreated::class => [
            DispatchRealTimeMessage::class
        ],
        ModuleWasInstalled::class => [
            AddEnvVars::class
        ],
    ];

    protected $bindings = [
        MessagesMessagesEntryModel::class => MessageModel::class,
        MessagesChatsEntryModel::class => ChatModel::class,
    ];

    protected $singletons = [
        MessageRepositoryInterface::class => MessageRepository::class,
        ChatRepositoryInterface::class => ChatRepository::class,
    ];

    protected $providers = [
        WebSocketsServiceProvider::class
    ];

    public function register()
    {
        Broadcast::channel('Anomaly.UsersModule.User.UserModel.{id}', function ($user, $id) {
            return (int) $user->id === (int) $id;
        });
    }
}
