<?php namespace Visiosoft\MessagesModule\Listeners;

use Anomaly\Streams\Platform\Addon\Module\Event\ModuleWasInstalled;

class AddEnvVars
{
    public function handle(ModuleWasInstalled $event)
    {
        if ($event->getModule()->getNamespace() === 'visiosoft.module.messages') {
            $path = base_path('.env');

            if (file_exists($path)) {
                if(strpos(file_get_contents($path), 'PUSHER_APP_ID') === false) {
                    file_put_contents($path, file_get_contents($path) . <<<env
                    
                    PUSHER_APP_ID=12345
                    PUSHER_APP_KEY=12345
                    PUSHER_APP_SECRET=12345
                    
                    env);
                }
            }
        }
    }
}
