<?php namespace Visiosoft\MessagesModule\Message;

use Visiosoft\MessagesModule\Message\Contract\MessageInterface;
use Anomaly\Streams\Platform\Model\Messages\MessagesMessagesEntryModel;

class MessageModel extends MessagesMessagesEntryModel implements MessageInterface
{
    protected $appends = [
        'formatted_date'
    ];

    public function getFormattedDateAttribute()
    {
        return $this->created_at->format(config('streams::datetime.date_format') . ' ' . config('streams::datetime.time_format'));
    }

    public function getReceiver()
    {
        return $this->chat->user_1_id == $this->created_by_id ? $this->chat->user_2 : $this->chat->user_1;
    }
}
