<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\MessagesModule\RelatedMessage\RelatedMessageModel;

class VisiosoftModuleMessagesCreateMessagesFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class,
                'mode' => 'search',
            ]
        ],
        'deleted_by_sender' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
            ]
        ],
        'deleted_by_receiver' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
            ]
        ],
        'user_1' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                'mode' => 'search',
            ],
        ],
        'user_2' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                'mode' => 'search',
            ],
        ],
        'chat' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MessagesModule\Chat\ChatModel::class,
            ],
        ],
        'title' => 'anomaly.field_type.text',
        'detail' => 'anomaly.field_type.textarea',
        'seen' => [
            'type'   => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
    ];

}
