<?php namespace Visiosoft\MessagesModule\Message;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;

class MessageCriteria extends EntryCriteria
{
    private $messageRepository;
    private $advRepository;
    private $chatRepository;

    public function __construct
    (
        Builder $query,
        StreamInterface $stream,
        $method,
        MessageRepositoryInterface $messageRepository,
        AdvRepositoryInterface $advRepository,
        ChatRepositoryInterface $chatRepository
    )
    {
        parent::__construct($query, $stream, $method);

        $this->messageRepository = $messageRepository;
        $this->advRepository = $advRepository;
        $this->chatRepository = $chatRepository;
    }

    public function getUserAdMessages($chatId) {
        // Mark unread messages
        $this->messageRepository
            ->newQuery()
            ->where('chat_id', $chatId)
            ->where('created_by_id', '!=', auth()->id())
            ->where('seen', 0)
            ->update(['seen' => 1]);

        return $this->messageRepository
            ->newQuery()
            ->where('chat_id', $chatId)
            ->where(function ($query) {
                $query->whereNull('deleted_by_sender_id')
                    ->orWhere('deleted_by_sender_id', '!=', auth()->id());
            })
            ->where(function ($query) {
                $query->whereNull('deleted_by_receiver_id')
                    ->orWhere('deleted_by_receiver_id', '!=', auth()->id());
            })
            ->orderBy('created_at')
            ->get();
    }

    public function checkUnreadMessages() {
        $myChats = $this->chatRepository->getChats()->pluck('id');

        return $this->messageRepository
            ->newQuery()
            ->whereIn('chat_id', $myChats)
            ->where('created_by_id', '!=', auth()->id())
            ->where('seen', 0)
            ->count();
    }
}