<?php namespace Visiosoft\MessagesModule\Notifications;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;


class MessagesModuleNotificationsTemplateSeeder extends Seeder
{
    use DispatchesJobs;

    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {

            $templates = [
                [
                    'en' => [
                        'message' => '<p><strong>You have a new message from {name}</strong></p><p>Message: {message}</p>',
                        'name' => 'Message Notification',
                        'greeting' => 'Hello',
                        'subject' => 'You have a new message'
                    ],
                    'stream' => 'messages',
                    'slug' => 'message_notification'
                ],
                [
                    'en' => [
                        'message' => '<p><strong>You sent a message to {name}</strong></p>
                                    <p>Message: {message}</p>',
                        'name' => 'Sender Message Notification',
                        'greeting' => 'Hi',
                        'subject' => 'You sent a message'
                    ],
                    'stream' => 'messages',
                    'slug' => 'sender_message_notification'
                ],
            ];

            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }

        }
    }
}