<?php namespace Visiosoft\MessagesModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\MessagesModule\Message\MessageRepository;

class MessagesModulePlugin extends Plugin
{
    private $messageRepo;
    public function __construct(
        MessageRepository $messageRepo
    )
    {
       $this->messageRepo = $messageRepo;
    }
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'get_env',
                function ($identifier) {
                    return env($identifier, null);
                }
            ),

            new \Twig_SimpleFunction(
                'get_unread_chat_count',
                function () {
                    return $this->messageRepo->getUnreadChatsCount();
                }
            ),
        ];
    }
}
