<?php namespace Visiosoft\MessagesModule\Http\Controller\Api;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Illuminate\Http\Request;

class MessagesController extends AdminController
{
    private $messageRepository;
    private $chatRepository;

    public function __construct(
        MessageRepositoryInterface $messageRepository,
        ChatRepositoryInterface $chatRepository
    )
    {
        parent::__construct();

        $this->messageRepository = $messageRepository;
        $this->chatRepository = $chatRepository;
    }

    public function listMessages(Request $request)
    {
        if ($request->type == 'inbox') {
            $messages = $this->messageRepository->newQuery()->where('adv_user_id', auth()->id())->get();
        } else {
            $messages = $this->messageRepository->newQuery()->Where('sender_id',auth()->id())->get();
        }
        $messages = $this->messageRepository->addAttributes($messages);
        return response()->json($messages);
    }

    public function save()
    {
        try {
            if (!request()->chat) {
                throw new \Exception('Chat not found!');
            }

            $chat = $this->chatRepository->find(request()->chat);
            $chat->update();

            $otherUser = $this->chatRepository->getOtherUser($chat->id);
            $message = $this->messageRepository->create([
                'title' => $otherUser->name(),
                'detail' => request()->detail,
                'chat' => $chat,
            ]);

            return [
                'success' => true,
                'data' => $message
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage(),
            ];
        }
    }

    public function show($id)
    {
        $message = $this->messageRepository->find($id);
        if (!is_null($message)) {
            $message->update([
                'status' => true,
                'sender_status' => true,
            ]);
            return response()->json(['message' => $message]);
        }
        abort(404);
    }

    public function update($id, Request $request)
    {
        $message = $this->messageRepository->find($id);
        if (!is_null($message)) {
            $message->update([
                'detail' => $request->detail,
                'sent_at' => date('Y-m-d H:i:s'),
                'sender_id' => auth()->id(),
            ]);
            return response()->json(['status' => 'success', 'message' => $message]);
        } else {
            return response()->json(['status' => 'fail']);
        }
    }
}
