<?php namespace Visiosoft\LoancalcModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\UserModel;
use Illuminate\Http\Request;
use Visiosoft\NotificationsModule\Notify\Notification\SendLoanApplicationMail;
use Visiosoft\NotificationsModule\Notify\NotifyModel;

class LoancalcController extends PublicController {

    private $userModel;
    private $notifyModel;

    public function __construct(UserModel $userModel, NotifyModel $notifyModel)
    {
        parent::__construct();

        $this->userModel = $userModel;
        $this->notifyModel = $notifyModel;
    }

    public function sendLoanApplication(Request $request)
    {
        $user = $this->notifyModel->getUser(1);
        $mail = $user->notify(new SendLoanApplicationMail($request->all()));
        return response()->json(['success' => true, 'content' => $request['firstName']]);
    }
}
