<?php

return [
    'client_id'         => [
        'required' => true,
        'env'      => 'Linkedin_CLIENT_ID',
        'bind'     => 'services.linkedin.client_id',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'client_secret'     => [
        'required' => true,
        'env'      => 'Linkedin_CLIENT_SECRET',
        'bind'     => 'services.linkedin.client_secret',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'scope'             => [
        'bind'   => 'services.linkedin.scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
            ],
        ],
    ],
    'application_scope' => [
        'bind'   => 'services.linkedin.application_scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
                'publish_actions',
            ],
        ],
    ],
];
