<?php namespace Visiosoft\LimupaTheme\Listeners;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Module\Event\ModuleWasInstalled;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;

class CreateFeaturedBlockArea
{
    protected $areas;

    public function __construct(AreaRepository $areas, AdvModel $advModel, TypeRepositoryInterface $typeRepository, FieldRepositoryInterface $fieldRepository, AssignmentRepositoryInterface $assignmentRepository, StreamRepositoryInterface $streamRepository)
    {
        $this->areas = $areas;
    }

    public function handle(ModuleWasInstalled $event)
    {
        if ($event->getModule()->getNamespace() == "visiosoft.module.dopings") {
            $areas = [
                [
                    'en' => [
                        'name' => 'Featured Left Area',
                        'description' => 'For the Limupa theme, the featured left ad space.',
                    ],
                    'tr' => [
                        'name' => 'Sol Öne Çıkan İlanlar Reklam Alanı',
                        'description' => 'Limupa teması için sol öne çıkan ilanlar reklam alanını temsil eder.',
                    ],
                    'slug' => 'limupa-left-featured',
                ]
            ];


            //Create Areas
            foreach ($areas as $area) {
                if (!$this->areas->findBySlug($area['slug'])) {
                    $this->areas->create(
                        $area
                    );
                }
            }

        }
    }
}