<?php namespace Visiosoft\LimupaTheme\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class LimupaController extends PublicController
{
    protected $categoryRepository;
    protected $advRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository, AdvRepositoryInterface $advRepository)
    {
        $this->categoryRepository = $categoryRepository;
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function getCategoryList($id)
    {
        if ($category = $this->categoryRepository->find($id)) {

            //get three sub categories
            $sub_categories = $this->categoryRepository->newQuery()
                ->where('parent_category_id', $id)
                ->limit(3)->orderByDesc('count')->get();

            if (count($sub_categories)) {
                $ads = $query = $this->advRepository->newQuery()
                    ->where('advs_advs.slug', '!=', "")
                    ->where('advs_advs.status', 'approved')
                    ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'))
                    ->whereIn('cat2', array_keys($sub_categories->pluck('name', 'id')->all()))
                    ->inRandomOrder()
                    ->limit(15)
                    ->get();

                if (count($ads)) {
                    return $this->response->json(['data' => [
                        'category' => $category,
                        'sub_categories' => $sub_categories,
                        'advs' => $ads,
                    ]]);
                }
            }
        }
        return $this->response->json(['data' => null]);
    }
}
