let getEntryImages = {
    thumbs(entry) {
        return this.generate(entry, 'sm-image');
    },
    slider(entry) {
        return this.generate(entry, 'lg-image');
    },
    generate(entry, attr_class) {
        let images = "";

        if (entry.files.length > 0) {
            $.each(entry.files, function (index, value) {
                images += `<div class="${attr_class}"><img src="http://oc3006.test/files/${value.path}" alt="${entry.name}"></div>`;
            });
        } else {
            images = `<div class="${attr_class}"><img src="${entry.thumbnail}" alt="${entry.name}"></div>`;
        }

        return images;
    }
};

let getSocialLink = {
    linkedin(detail_url) {
        return "https://www.linkedin.com/sharing/share-offsite/?url=" + encodeURIComponent(detail_url);
    },
    whatsapp(detail_url) {
        return "https://wa.me/?text=" + encodeURIComponent(whatsapp_share_message) + "%20" + encodeURIComponent(detail_url);
    },
    facebook(detail_url) {
        return "https://www.facebook.com/sharer/sharer.php?u=" + encodeURIComponent(detail_url);
    },
    twitter(detail_url) {
        return "http://twitter.com/share?url=" + encodeURIComponent(detail_url);
    },
};


let initSlider = {
    slider(element, nav = null) {
        this.init(element, {
            arrows: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: false,
            autoplaySpeed: 5000,
            dots: false,
            infinite: true,
            centerMode: false,
            centerPadding: 0,
            asNavFor: nav
        })
    },
    thumbnail(element, nav = null) {
        this.init(element, {
            slidesToShow: 3,
            slidesToScroll: 1,
            autoplay: false,
            autoplaySpeed: 5000,
            dots: false,
            infinite: true,
            focusOnSelect: true,
            centerMode: true,
            centerPadding: 0,
            prevArrow: '<span class="slick-prev"><i class="fa fa-angle-left"></i></span>',
            nextArrow: '<span class="slick-next"><i class="fa fa-angle-right"></i></span>',
            asNavFor: nav
        })
    },
    init(element, options) {
        element.slick(options);
    }
};


function quickView(id) {
    let modal = $('#quickViewModal');

    $('.product-variants').remove();

    modal.modal('show');
    let entry = getDetail(id);

    let initAdDetail = new Promise(function (response) {

        // Init Loader
        $('.quick-loader').removeClass('d-none');
        $('.quick-detail').addClass('d-none');

        // Set Detail
        modal.find('.quick-title').html(entry.name);
        modal.find('.quick-description').html(entry.advs_desc);
        modal.find('.quick-price').html(entry.currency_price);

        // Add Images
        $('.product-details-left').html(`
<div class="product-details-images quick-slider-${entry.id} slider-navigation-1">${getEntryImages.slider(entry)}</div>
<div class="product-details-thumbs quick-thumbnail-${entry.id} slider-thumbs-1">${getEntryImages.thumbs(entry)}</div>
`);

        // Add Configuration
        if (entry.configurations.length > 0) {
            let configuration_field = `<div class="product-variants">
                    <div class="produt-variants-size"><label>Dimension</label><select class="nice-select mb-4 configuration-select-${entry.id} wide">`;

            // Each Configurations
            $.each(entry.configurations, function (index, value) {
                let selected = (index == 0) ? 'selected' : '';
                configuration_field += `<option value="${value.id}" title="${value.option_name}" ${selected}>${value.option_name}</option>`;
            });

            configuration_field += `</select></div></div>`;

            $('.product-desc').after(configuration_field);

            //Refresh Select Extension
            $('.configuration-select-' + entry.id).niceSelect();
        }

        // Init Social Links
        modal.find('.facebook a').attr('href',getSocialLink.facebook(entry.detail_url));
        modal.find('.twitter a').attr('href',getSocialLink.twitter(entry.detail_url));
        modal.find('.linkedin a').attr('href',getSocialLink.linkedin(entry.detail_url));
        modal.find('.whatsapp a').attr('href',getSocialLink.whatsapp(entry.detail_url));

        response(true);
    });

    // Remove Loader
    initAdDetail.then(function () {
        $('.quick-loader').addClass('d-none');
        $('.quick-detail').removeClass('d-none');

        initSlider.slider($('.quick-slider-' + entry.id), $('.quick-thumbnail-' + entry.id))
        initSlider.thumbnail($('.quick-thumbnail-' + entry.id), $('.quick-slider-' + entry.id))
    });
}


function getDetail(id) {
    let entry = null;

    //Get Detail
    crudAjax('', '/api/entries/advs/advs/' + id, 'GET', function (response) {
        if (response.data) {
            entry = response.data;
        }
    });

    if (entry) {
        // Get Images
        crudAjax('', '/api/entries/advs/advs/' + id + '/files/get', 'GET', function (response) {
            if (response.data) {
                entry.files = response.data;
            }
        });

        // Get Configurations
        crudAjax('', '/api/entries/advs/advs/' + id + '/configurations/get', 'GET', function (response) {
            if (response.data) {
                entry.configurations = response.data;
            }
        });
    }

    return entry;
}

