//Homepage Categories Area
let owl_products_category_options = {
    loop: true,
    nav: true,
    dots: false,
    autoplay: false,
    autoplayTimeout: 5000,
    navText: ["<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>"],
    item: 5,
    responsive: {
        0: {
            items: 1
        },
        480: {
            items: 2
        },
        768: {
            items: 3
        },
        992: {
            items: 4
        },
        1200: {
            items: 5
        }
    }
};

$.each(homepage_categories_advs, function (i, v) {
    crudAjax('', v, 'GET', function (response) {
        if (response.data) {
            section = `
            <section id="home-categories-area" class="product-area pb-45">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="li-section-title">
                            <h2>
                                <span>${response.data.category.name}</span>
                            </h2>
                            <ul class="li-sub-category-list">`;

            //Loop sub-categories
            $.each(response.data.sub_categories, function (index, value) {
                section += `<li><a href="${generateCategoryUrl(value.slug)}">${value.name}</a></li>`;
            });

            section += `</ul></div><div class="row"><div class="product-active category-products-${i} owl-carousel">`;

            $.each(response.data.advs, function (key, adv) {
                section +=
                    `<div class="col-lg-12"><div class="single-product-wrap">
                 <div class="product-image"><a href="${adv.detail_url}"><img src="${adv.thumbnail}" alt="p_name"></a>
                 </div><div class="product_desc"><div class="product_desc_info"> <div class="product-review"><h5 class="manufacturer">
                 <a href="${generateCategoryUrl(adv.category2.slug)}">${adv.category2.name}</a></h5>
                 <div class="rating-box"><ul class="rating">
                 <li><i class="fas fa-star"></i></li>
                 <li><i class="fas fa-star"></i></li>
                 <li><i class="fas fa-star"></i></li>
                 <li class="no-star"><i class="fas fa-star"></i></li>
                 <li class="no-star"><i class="fas fa-star"></i></li>
                 </ul></div></div>
                 <h4><a class="product_name" href="${adv.detail_url}">${adv.name}</a></h4>
                 <div class="price-box"><span class="new-price">${adv.currency_price}</span></div></div>
                 <div class="add-actions">
                 <ul class="add-actions-link" data-id="${adv.id}">
                 <li class="add-cart active"><span onclick="quickView(${adv.id})">Add to cart</span></li>
                 <li><span title="quick view" onclick="quickView(${adv.id})"><i class="fa fa-eye"></i></span></li>
                 </ul></div></div></div></div>`;
            });

            section += `</div></div></div></div></div></section>`;


            $('.li-bottom-banner').before(section);
        }

        return response;
    }).then(function (response) {
        if (response.data) {
            $(".category-products-" + i).owlCarousel(owl_products_category_options);
        }
    });
});


let initIndexBlocks = new Promise(function (response) {
    addIndexBlocks();
    response(true);
});

initIndexBlocks.then(function () {
    let completed_index_blocks = new CustomEvent('completedIndexBlocks');
    window.dispatchEvent(completed_index_blocks);
});

function addIndexBlocks() {
    let actions_elements = $('#home-categories-area .add-actions-link')
    $.each(actions_elements, function (index, elements) {
        let element = $(this).find('.add-cart');
        element.after(index_actions_blocks.replace(':id', element.data('id')))
    });
}

function generateCategoryUrl(slug) {
    return default_category_url.replace("slug", slug);
}

$(".product-active").owlCarousel({
    loop: true,
    nav: true,
    dots: false,
    autoplay: false,
    autoplayTimeout: 5000,
    navText: ["<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>"],
    item: 5,
    responsive: {
        0: {
            items: 1
        },
        480: {
            items: 2
        },
        768: {
            items: 3
        },
        992: {
            items: 4
        },
        1200: {
            items: 5
        }
    }
});