<?php namespace Visiosoft\LimupaTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;

class LimupaThemeSeeder extends Seeder
{
    protected $areas;
    protected $fieldRepository;
    protected $assignmentRepository;
    protected $streamRepository;
    protected $typeRepository;
    protected $advModel;

    public function __construct(AreaRepository $areas, AdvModel $advModel, TypeRepositoryInterface $typeRepository, FieldRepositoryInterface $fieldRepository, AssignmentRepositoryInterface $assignmentRepository, StreamRepositoryInterface $streamRepository)
    {
        $this->areas = $areas;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
        $this->typeRepository = $typeRepository;
        $this->advModel = $advModel;

        parent::__construct();
    }

    public function run()
    {

        $areas = [
            [
                'en' => [
                    'name' => 'Right Slider Area',
                    'description' => 'For the Limupa theme, the slider represents the right ad space.',
                ],
                'tr' => [
                    'name' => 'Slider Sağ Reklam Alanı',
                    'description' => 'Limupa teması için slider sağ reklam alanını temsil eder.',
                ],
                'slug' => 'limupa-right-slider',
            ],
            [
                'en' => [
                    'name' => 'Bottom Slider Area',
                    'description' => 'For the Limupa theme, the slider represents the bottom ad space.',
                ],
                'tr' => [
                    'name' => 'Slider Alt Reklam Alanı',
                    'description' => 'Limupa teması için slider alt reklam alanını temsil eder.',
                ],
                'slug' => 'limupa-bottom-slider',
            ],
            [
                'en' => [
                    'name' => 'Bottom Area',
                    'description' => 'For the Limupa theme, the bottom ad space.',
                ],
                'tr' => [
                    'name' => 'Alt Reklam Alanı',
                    'description' => 'Limupa teması için alt reklam alanını temsil eder.',
                ],
                'slug' => 'limupa-bottom',
            ]
        ];


        //Create Areas

        foreach ($areas as $area) {
            if (!$this->areas->findBySlug($area['slug'])) {
                $this->areas->create(
                    $area
                );
            }
        }

        //Create Block Type
        $types = [
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Advertising Image',
                    ],
                    'tr' => [
                        'name' => 'Reklam Görseli',
                    ],
                ],
                'slug' => 'advertising_image',
            ]
        ];

        foreach ($types as $type) {
            $exists_type = $this->typeRepository->findBySlug($type['slug']);
            if (!$exists_type) {
                $this->typeRepository->create(array_merge([
                    'category' => 'other',
                    'slug' => $type['slug'],
                ], $type['name_fields']));
            }
        }

        //Create Blocks Fields
        $typesStream = $this->streamRepository->findBySlugAndNamespace('advertising_image_blocks', 'blocks');

        $blocksFields = [
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Advertising Image',
                    ],
                    'tr' => [
                        'name' => 'Reklam Görseli',
                    ],
                ],
                'slug' => 'advertising_image',
                'namespace' => 'blocks',
                'translatable' => false,
                'type' => 'anomaly.field_type.file',
                "config" => [
                    "required" => true,
                    "folders" => ['images'],
                ],
            ],
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Advertising Image URL',
                    ],
                    'tr' => [
                        'name' => 'Reklam Görseli URL',
                    ],
                ],
                'slug' => 'advertising_image_url',
                'namespace' => 'blocks',
                'type' => 'anomaly.field_type.text',
                'translatable' => false,
                "config" => [
                    "required" => true,
                    "default_value" => "#",
                ],
            ],

        ];

        foreach ($blocksFields as $blocksField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fieldRepository->create(array_merge([
                    'namespace' => $blocksField['namespace'],
                    'slug' => $blocksField['slug'],
                    'type' => $blocksField['type'],
                    'locked' => 0,
                    "config" => $blocksField['config']
                ],$blocksField['name_fields']));
            }

            $assign = $this->assignmentRepository->findByStreamAndField($typesStream, $field);
            if (!$assign) {
                $this->assignmentRepository->create([
                    'stream_id' => $typesStream->getId(),
                    'field_id' => $field->id,
                    'translatable' => $blocksField['translatable']
                ]);
            }
        }

        //Slider Seeder

        $fields_slider = [
            [
                'en' => [
                    'name' => 'Content',
                ],
                'tr' => [
                    'name' => 'İçerik',
                ],
                'namespace' => 'slider',
                'slug' => 'limupa_slider_content',
                'type' => 'anomaly.field_type.wysiwyg',
                'config' => [
                    'default_value' => ' <h5>Sale Offer <span>-20% Off</span> This Week</h5>
                    <h2>Chamcham Galaxy S9 | S9+</h2>
                    <h3>Starting at <span>$589.00</span></h3>'
                ],
                'locked' => 0,
            ],
            [
                'en' => [
                    'name' => 'Button Text',
                ],
                'tr' => [
                    'name' => 'Buton Yazısı',
                ],
                'namespace' => 'slider',
                'slug' => 'limupa_slider_button_text',
                'type' => 'anomaly.field_type.text',
                'config' => [
                    'default_value' => 'Shopping Now'
                ],
                'locked' => 0,
            ]
        ];

        $sliderStream = $this->streamRepository->findBySlugAndNamespace('sliders', 'slider');

        foreach ($fields_slider as $slider_field) {
            if ($this->advModel->is_enabled('slider') && !$this->fieldRepository->findBySlugAndNamespace($slider_field['slug'], 'slider')) {
                $field = $this->fieldRepository->create($slider_field);
                $this->assignmentRepository->create([
                    'stream_id' => $sliderStream->getId(),
                    'field_id' => $field->id,
                    'translatable' => true
                ]);
            }
        }

    }
}
